const mysql = require("mysql2/promise"); // Import the promise-based version of mysql2
require("dotenv").config();

// Create a connection pool with promise support
const db = mysql.createPool({
  host: process.env.DB_HOST,
  user: process.env.DB_USER,
  password: process.env.DB_PASSWORD,
  database: process.env.DB_NAME,
  waitForConnections: true,
  connectionLimit: 10, // Max number of connections in the pool
  queueLimit: 0, // 0 means unlimited
  dateStrings: true, // THIS is the key
});

console.log("Connected to MySQL database");

module.exports = db;
