const jwt = require("jsonwebtoken");
const bcrypt = require("bcrypt");
const db = require("../config/db"); // Assuming you have set up the database connection

const generateOTP = () => {
  return Math.floor(100000 + Math.random() * 900000); // Generates a 4-digit OTP
};

const login = async (req, res) => {
  const { email_id, phone_number, password } = req.body;

  console.log(email_id, phone_number, password);

  if ((!email_id && !phone_number) || !password) {
    return res.status(400).json({
      message: "Email or phone number and password are required",
    });
  }

  try {
    let query, queryParams;

    // if (email_id) {
    //   // query = "SELECT * FROM users WHERE email = ? AND deleted = ? AND status IN ("active","inactive","closed","on-hold") LIMIT 1";
    //   query =
    //     "SELECT * FROM users WHERE email = ? AND deleted = ? AND status IN ('active', 'inactive', 'closed', 'on-hold') LIMIT 1";

    //   queryParams = [email_id, "0"];
    // } else {
    //   // query = "SELECT * FROM users WHERE phone_number = ? AND deleted = ?";
    //   query =
    //     "SELECT * FROM users WHERE phone_number = ? AND deleted = ? AND status IN ('active', 'inactive', 'closed', 'on-hold')";
    //   queryParams = [phone_number, "0"];
    // }

    if (email_id) {
      query =
        "SELECT * FROM users WHERE email = ? AND deleted = ? AND status = 'active' LIMIT 1";
      queryParams = [email_id, "0"];
    } else {
      query =
        "SELECT * FROM users WHERE phone_number = ? AND deleted = ? AND status = 'active' LIMIT 1";
      queryParams = [phone_number, "0"];
    }

    const [results] = await db.query(query, queryParams);

    if (results.length === 0) {
      return res.status(401).json({ message: "Invalid credentials" });
    }

    const user = results[0];

    // Check password using bcrypt
    const match = await bcrypt.compare(password, user.password);

    // console.log("Match", match, user);

    if (!match) {
      return res.status(401).json({ message: "Invalid credentials" });
    }

    // If role is admin, allow direct login
    if (user.role === "admin") {
      return proceedToLogin(user, res);
    }

    // // Else, check user_details for donor_id
    // const [userDetails] = await db.query(
    //   "SELECT * FROM user_details WHERE user_id = ?",
    //   [user.id]
    // );

    // if (userDetails.length === 0) {
    //   return res
    //     .status(401)
    //     .json({ message: "User details not found. Contact support." });
    // }

    // const userDetail = userDetails[0];

    if (!user.donor_id || user.donor_id.trim() === "") {
      // return res
      //   .status(403)
      //   .json({ message: "Access denied. Patronship number missing." });
      return res.status(403).json({ message: "Invalid Credentials." });
    }

    // All checks passed → proceed to login
    return proceedToLogin(user, res);
  } catch (error) {
    console.error("Login error:", error);
    return res.status(500).json({ message: "An error occurred", error });
  }
};

const proceedToLogin = async (user, res) => {
  try {
    // const accessToken = jwt.sign(
    //   {
    //     user_id: user.id,
    //     email: user.email,
    //     role: user.role,
    //     contact_id: user?.contact_id,
    //     donor_id: user.donor_id,
    //     is_volunteer: user?.is_volunteer,
    //   },
    //   process.env.JWT_SECRET_KEY,
    //   { expiresIn: "10s" },
    // );
    const accessToken = jwt.sign(
      {
        user_id: user.id,
        email: user.email,
        role: user.role,
        contact_id: user?.contact_id,
        donor_id: user.donor_id,
        is_volunteer: user?.is_volunteer,
      },
      process.env.JWT_SECRET_KEY,
      { expiresIn: "24h" },
    );

    const refreshToken = jwt.sign(
      {
        user_id: user.id,
        role: user.role,
        email: user.email,
        contact_id: user?.contact_id,
        donor_id: user.donor_id,
        is_volunteer: user?.is_volunteer,
      },
      process.env.JWT_REFRESH_SECRET_KEY,

      { expiresIn: "30d" },
    );

    // Optional: Store refresh token
    await db.query("UPDATE users SET refresh_token = ? WHERE id = ?", [
      refreshToken,
      user.id,
    ]);

    return res.json({
      message: "Login successful",
      accessToken,
      refreshToken,
      user: {
        email: user.email,
        phone_number: user.phone_number,
        role: user.role,
        full_name: user.full_name,
        user_id: user.id,
        is_volunteer: user?.is_volunteer,
      },
    });
  } catch (err) {
    console.error("Token generation error:", err);
    return res.status(500).json({ message: "Login failed", error: err });
  }
};

const logout = (req, res) => {
  res.clearCookie("refreshToken", {
    httpOnly: true,
    secure: process.env.NODE_ENV === "production",
    sameSite: "Strict",
  });
  res.json({ message: "Logged out successfully" });
};

const refreshAccessToken = async (req, res) => {
  const { refreshToken } = req.body;

  if (!refreshToken) {
    return res.status(403).json({ message: "Refresh token is required" });
  }

  try {
    // Verify the refresh token
    const decoded = jwt.verify(
      refreshToken,
      process.env.JWT_REFRESH_SECRET_KEY,
    );

    // console.log("Decoded",decoded)

    // // Optionally check if the refresh token is stored in the database
    // const [user] = await db.query("SELECT * FROM users WHERE id = ?", [
    //   decoded.user_id,
    // ]);
    // if (!user || user.refresh_token != refreshToken) {
    //   return res.status(403).json({ message: "Invalid refresh token", user_id:decoded.user_id  });
    // }

    // Generate a new access token
    // const accessToken = jwt.sign(
    //   {
    //     user_id: decoded.user_id,
    //     email: decoded.email,
    //     role: decoded.role,
    //     contact_id: decoded.contact_id,
    //     donor_id: decoded.donor_id,
    //     is_volunteer: decoded?.is_volunteer,
    //   },
    //   process.env.JWT_SECRET_KEY,
    //   { expiresIn: "5s" },
    // );

    const accessToken = jwt.sign(
      {
        user_id: decoded.user_id,
        email: decoded.email,
        role: decoded.role,
        contact_id: decoded.contact_id,
        donor_id: decoded.donor_id,
        is_volunteer: decoded?.is_volunteer,
      },
      process.env.JWT_SECRET_KEY,
      { expiresIn: "24h" },
    );

    res.json({ accessToken: accessToken });
  } catch (error) {
    res.status(403).json({ message: "Invalid or expired refresh token" });
  }
};

module.exports = {
  login,
  logout,
  refreshAccessToken,
};
