const db = require("../config/db");

const getAllCategoryTypes = async (req, res) => {
  try {
    const page = parseInt(req.query.page) || 1;
    const limit = parseInt(req.query.limit) || 100;
    const offset = (page - 1) * limit;

    // Total count
    const [countResult] = await db.query(
      "SELECT COUNT(*) AS total FROM category_types",
    );
    const total = countResult[0].total;

    // Fetch projects with pagination
    const query = `SELECT * FROM category_types LIMIT ? OFFSET ?`;
    const [result] = await db.execute(query, [limit, offset]);

    // If no projects found
    if (result.length === 0) {
      return res.status(404).json({
        success: false,
        message: "No category types found.",
      });
    }

    // Return categories with pagination info
    return res.json({
      success: true,
      categories: result,
      currentPage: page,
      totalPages: Math.ceil(total / limit),
      totalRecords: total,
    });
  } catch (error) {
    console.error("Get Categories Error:", error);
    return res.status(500).json({
      success: false,
      message: "Server error.",
    });
  }
};



module.exports = {
  getAllCategoryTypes,
};