const multer = require("multer");
const path = require("path");
const fs = require("fs");

// Helper function folder create karne ke liye agar exist nahi karta
const ensureDirExists = (dir) => {
  if (!fs.existsSync(dir)) {
    fs.mkdirSync(dir, { recursive: true });
  }
};

const storage = multer.diskStorage({
  destination: (req, file, cb) => {
    const now = new Date();
    const year = now.getFullYear().toString(); // e.g., "2025"
    const month = (now.getMonth() + 1).toString().padStart(2, "0"); // e.g., "10"

    // Decide folder based on mime type
    let folderType = "others";
    if (file.mimetype.startsWith("image/")) {
      folderType = "images";
    } else if (file.mimetype.startsWith("video/")) {
      folderType = "videos";
    }

    // Full upload path: uploads/{year}/{month}/{images|videos}
    const uploadPath = path.join("uploads", year, month, folderType);

    // Ensure directory exists
    ensureDirExists(uploadPath);

    cb(null, uploadPath);
  },
  filename: (req, file, cb) => {
    // Unique filename: timestamp + original extension
    const uniqueSuffix = Date.now() + "-" + Math.round(Math.random() * 1e9);
    const ext = path.extname(file.originalname);
    cb(null, uniqueSuffix + ext);
  },
});

const fileFilter = (req, file, cb) => {
  const allowedTypes = [
    "image/jpeg",
    "image/png",
    "image/jpg",
    "image/webp",
    "video/mp4",
    "video/mpeg",
    // add more types if needed
  ];
  if (allowedTypes.includes(file.mimetype)) {
    cb(null, true);
  } else {
    cb(new Error("Invalid file type. Only images and videos are allowed."));
  }
};

const upload = multer({ storage, fileFilter });

module.exports = upload;
