const express = require("express");
const {
  createBlog,
  getAllBlogs,
  getBlogById,
  updateBlog,
  deleteBlog,
  changeBlogStatus,
  checkSlugExist,
} = require("../controllers/blogController");

const router = express.Router();

// Create a new blog
router.post("/", createBlog);

// Get all blogs with pagination
router.get("/get-blogs", getAllBlogs);

// Get a blog by ID
router.get("/:id", getBlogById);

// Update a blog by ID
router.put("/:id", updateBlog);

// Delete a blog by ID
router.delete("/:id", deleteBlog);

router.get("/check-slug-exist/:slug", checkSlugExist);

router.put("/change-blog-status/:blogId", changeBlogStatus);

module.exports = router;
