const express = require("express");
const {
  createCategory,
  getCategoryById,
  getAllCategories,
  updateCategory,
  deleteCategory,
  checkCategorySlugExist,
  projectCategories,
  projectCategoriesBySlug,
  changeCategoryStatus,
  getCategories,
} = require("../controllers/categoriesController");

const router = express.Router();

// Create a new category
router.post("/", createCategory);

// Get All Catgeories without filter and pagination
router.get("/", getCategories);

// Get all categories with pagination
router.get("/get-categories", getAllCategories);

// Get all categories for project
router.get("/project-categories", projectCategories);

// Get all categories for project
router.get("/project-categories/:slug", projectCategoriesBySlug);

// Get a category by ID
router.get("/:id", getCategoryById);

// Update a category by ID
router.put("/:id", updateCategory);

// Delete a category by ID
router.delete("/:id", deleteCategory);

// Check slug exist
router.get("/check-slug-exist/:slug", checkCategorySlugExist);

router.put("/change-category-status/:categoryId", changeCategoryStatus);

module.exports = router;
