const fs = require("fs");
const path = require("path");
const axios = require("axios"); // Import axios for making HTTP requests
const nodemailer = require("nodemailer");
const handlebars = require("handlebars");
const pdf = require("html-pdf");
const { uploadFileToBunny } = require("./bunnyFunctions");
const sendWhatsAppTemplateMessage = require("./sendWhatsappTemplate");
const { generateOTP } = require("./generateOtp");

// SMTP configuration for CPanel (adjust as needed)
const transporter = nodemailer.createTransport({
  host: process.env.SMTP_HOSTNAME,
  port: 465, // or 587
  secure: true, // true for 465, false for 587
  auth: {
    user: process.env.SMTP_EMAIL,
    pass: process.env.SMTP_PASSWORD,
  },
});


async function sendMail({ name, phone, amount, email, invoice_id, mediaUrl }) {
  const pdfFileName = `donation-receipt-${invoice_id}.pdf`;

  const mailOptions = {
    from: `"FOLK ISKCON Kanpur" <${process.env.SMTP_EMAIL}>`,
    to: email,
    subject: "Your Donation Receipt - Thank You!",
    text: `Dear ${name},\n\nThank you so much for your generous contribution. Your support plays a vital role in helping us serve the mission of spreading Krishna consciousness and supporting various devotional and outreach activities.\n\nPlease find attached your donation receipt for your records.\n\nWe deeply value your association and encouragement.\n\nWith gratitude and best wishes,\n\nFOLK – ISKCON Kanpur\n\nHare Krishna!`,
    attachments: [
      {
        filename: pdfFileName,
        path: mediaUrl, // if using Bunny CDN public URL
      },
    ],
  };

  try {
    await transporter.sendMail(mailOptions);
    console.log(" Email sent to", email);
    return { success: true };
  } catch (err) {
    console.error("Email sending failed", err.message);
    return { success: false };
  }
}

const sendResetOtpToEmail = async (email,otp) => {
  try {
    // 1. Load and compile the email template
    const templatePath = path.join(
      __dirname,
      "../templates/ResetPasswordTemplate.html"
    );
    const html = fs.readFileSync(templatePath, "utf8");
    const template = handlebars.compile(html);

    

    // 3. Inject OTP into template
    const htmlToSend = template({ otp });


    // 4. Define email options
    const mailOptions = {
      from: `"Folk ERP" <${process.env.SMTP_EMAIL}>`,
      to: email,
      subject: "Reset Your Password - OTP Inside",
      html: htmlToSend,
    };

    // 5. Send the email
    await transporter.sendMail(mailOptions);

    console.log(`Reset OTP sent to ${email}`);

    // 6. Return OTP for backend to save/verify later
    return { success: true, otp };
  } catch (err) {
    console.error("Failed to send OTP:", err);
    return { success: false, message: err.message };
  }
};



module.exports =  {sendMail,sendResetOtpToEmail} 